document.addEventListener('DOMContentLoaded', async () => {
    const elements = {
        mainContent: document.getElementById('mainContent'),
        errorContainer: document.getElementById('errorContainer'),
        loginButton: document.getElementById('loginButton'),
        userAvatar: document.getElementById('userAvatar'),
        userName: document.getElementById('userName'),
        companyName: document.getElementById('companyName'),
        planName: document.getElementById('planName'),
        subscriptionStatus: document.getElementById('subscriptionStatus'),
        remainingDays: document.getElementById('remainingDays'),
        remainingMessages: document.getElementById('remainingMessages'),
        totalChatbots: document.getElementById('totalChatbots'),
        totalConversations: document.getElementById('totalConversations'),
        todayMessages: document.getElementById('todayMessages'),
        totalProducts: document.getElementById('totalProducts'),
        recentConversations: document.getElementById('recentConversations')
    };

    // Kiểm tra aiButton trong content script
    async function checkAIButton() {
        try {
            // Lấy tab hiện tại
            const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
            if (tab && tab.url.includes('business.facebook.com/latest/inbox')) {
                // Gửi tin nhắn đến content script để kiểm tra aiButton
                chrome.tabs.sendMessage(tab.id, { type: 'check_ai_button' });
            }
        } catch (error) {
            console.error('Lỗi khi kiểm tra AI Button:', error);
        }
    }

    // Xử lý sự kiện click nút đăng nhập
    elements.loginButton.addEventListener('click', () => {
        chrome.tabs.create({ url: 'https://xneva.vn/web/login' });
        window.close();
    });

    // Hàm hiển thị trạng thái đăng nhập/lỗi
    function showLoginError() {
        elements.mainContent.style.display = 'none';
        elements.errorContainer.style.display = 'block';
    }

    try {
        // Gọi API để lấy thông tin phiên làm việc
        const sessionResponse = await fetch('https://xneva.vn/web/session/get_session_info', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                jsonrpc: '2.0',
                id: null
            })
        });

        if (!sessionResponse.ok) {
            throw new Error('Network response was not ok');
        }

        const sessionData = await sessionResponse.json();
        
        if (sessionData.error) {
            throw new Error(sessionData.error.message || 'Unknown error occurred');
        }

        const sessionResult = sessionData.result;

        // Cập nhật thông tin người dùng từ session
        elements.userAvatar.textContent = sessionResult.name.charAt(0).toUpperCase();
        elements.userName.textContent = sessionResult.name;
        elements.companyName.textContent = sessionResult.user_companies.allowed_companies[sessionResult.user_companies.current_company].name;

        // Gọi API dashboard với thông tin user_context từ session
        const dashboardResponse = await fetch('https://xneva.vn/web/dataset/call_kw/ai.dashboard/get_dashboard_data', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                jsonrpc: '2.0',
                method: 'call',
                params: {
                    model: 'ai.dashboard',
                    method: 'get_dashboard_data',
                    args: [],
                    kwargs: {
                        context: {
                            lang: sessionResult.user_context.lang,
                            tz: sessionResult.user_context.tz,
                            uid: sessionResult.user_context.uid,
                            allowed_company_ids: [sessionResult.user_companies.current_company]
                        }
                    }
                }
            })
        });

        if (!dashboardResponse.ok) {
            throw new Error('Dashboard API failed');
        }

        const dashboardData = await dashboardResponse.json();
        
        if (dashboardData.error) {
            throw new Error(dashboardData.error.message || 'Dashboard error occurred');
        }

        const dashboard = dashboardData.result[0];

        // Cập nhật thông tin gói dịch vụ
        elements.planName.textContent = dashboard.current_plan_name;
        elements.subscriptionStatus.textContent = dashboard.subscription_state === 'active' ? 'Đang hoạt động' : 'Hết hạn';
        elements.subscriptionStatus.className = `subscription-status status-${dashboard.subscription_state}`;
        
        // Cập nhật thông tin còn lại
        elements.remainingDays.textContent = dashboard.remaining_days;
        elements.remainingMessages.textContent = dashboard.remaining_messages.toLocaleString();
        
        // Cập nhật thống kê
        elements.totalChatbots.textContent = dashboard.total_chatbots;
        const totalConvs = dashboard.total_facebook_conversations + 
                         dashboard.total_zalo_conversations + 
                         dashboard.total_telegram_conversations + 
                         dashboard.total_web_conversations;
        elements.totalConversations.textContent = totalConvs.toLocaleString();
        elements.todayMessages.textContent = dashboard.today_messages.toLocaleString();
        elements.totalProducts.textContent = dashboard.total_products.toLocaleString();

        // Hiển thị hội thoại gần đây
        if (dashboard.recent_conversations && dashboard.recent_conversations.length > 0) {
            const conversationsHtml = dashboard.recent_conversations
                .slice(0, 3) // Chỉ hiển thị 3 hội thoại gần nhất
                .map(conv => `
                    <div class="recent-item">
                        <div>${conv.name}</div>
                        <div class="recent-time">${new Date(conv.last_message_time).toLocaleString()}</div>
                        <div>${conv.last_message_short}</div>
                    </div>
                `).join('');
            elements.recentConversations.innerHTML = conversationsHtml;
        } else {
            elements.recentConversations.innerHTML = '<div class="recent-item">Không có hội thoại gần đây</div>';
        }

        // Hiển thị nội dung chính nếu mọi thứ thành công
        elements.mainContent.style.display = 'block';
        elements.errorContainer.style.display = 'none';

        // Kiểm tra aiButton sau khi đã đăng nhập thành công
        await checkAIButton();

    } catch (error) {
        console.error('Error:', error);
        showLoginError();
    }
});