// Xử lý các request API từ content script
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.type === 'api_call') {
        fetch(request.url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(request.data)
        })
        .then(response => response.json())
        .then(data => {
            sendResponse({ success: true, data });
        })
        .catch(error => {
            console.error('API call error:', error);
            sendResponse({ success: false, error: error.message });
        });
        return true; // Giữ kết nối để async sendResponse
    }

    if (request.type === 'get_session_info') {
        fetch('https://xneva.vn/web/session/get_session_info', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                jsonrpc: '2.0',
                id: null
            })
        })
        .then(response => response.json())
        .then(data => {
            sendResponse({ success: true, data });
        })
        .catch(error => {
            console.error('Session info error:', error);
            sendResponse({ success: false, error: error.message });
        });
        return true;
    }
});

// Lưu trữ cookie phiên làm việc
chrome.cookies.onChanged.addListener((changeInfo) => {
    if (changeInfo.cookie.domain.includes('xneva.vn')) {
        console.log('Cookie changed:', changeInfo);
    }
});